#ifndef _CREATETRIGGERS_CPP
#define _CREATETRIGGERS_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <WindowsX.H>
#include <ShellAPI.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <SQL.H>
#include <SQLExt.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../Resources/Resource.H"
#include "../../SharedClasses/CStatusDlg/CStatusDlg.H"
#include "../../SharedClasses/CRC32/CRC.H"
#include "../../SharedClasses/SQLClass/cSQL.H"
#include "../../SharedClasses/SQLClass/cRecordSet.H"
#include "../../SharedClasses/CGetPKs/CGetPKs.H"
#include "../../SharedSource/SQLTemplate.H"
#include "../CSockSrvr/CSockSrvr.H"

#include "../../SharedSource/NSWFL.H"
#include "Init.H"
#include "Entry.H"
#include "Routines.H"
#include "Console.H"
#include "Replication.H"

#include "../Dialogs/ReplicationDlg.H"
#include "../Dialogs/MainDlg.H"

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//This function is complete!
bool DropReplicationTriggers(CSQL *lpCSQL, char *sDB, char *sTable)
{
	//WriteCon("DropReplicationTriggers\n");

	char sSQL[1024];
	bool bThrowErrors = lpCSQL->bThrowErrors;

	lpCSQL->bThrowErrors = false;

	sprintf(sSQL, "DROP TRIGGER [SQLExch_%s_%s_Update_Trigger]", sDB, sTable);
	lpCSQL->ExecuteNonQuery(sSQL);

	sprintf(sSQL, "DROP TRIGGER [SQLExch_%s_%s_Delete_Trigger]", sDB, sTable);
	lpCSQL->ExecuteNonQuery(sSQL);

	lpCSQL->bThrowErrors = bThrowErrors;

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//This function is complete!
bool DropReplicationTables(CSQL *lpCSQL, char *sTrgDB, char *sDB, char *sDBO, char *sTable)
{
	//WriteCon("DropReplicationTables\n");

	char sSQL[1024];
	bool bThrowErrors = lpCSQL->bThrowErrors;

	lpCSQL->bThrowErrors = false;

	sprintf(sSQL, "DROP TABLE [%s].[%s].[SQLExch_%s_%s_Trans]", sTrgDB, sDBO, sDB, sTable);
	lpCSQL->ExecuteNonQuery(sSQL);

	sprintf(sSQL, "DELETE FROM [%s].[%s].[SQLExch_Trans]"
		" WHERE TransDB = '%s' AND TransTable = '%s'", sTrgDB, sDBO, sDB, sTable);
	lpCSQL->ExecuteNonQuery(sSQL);

	lpCSQL->bThrowErrors = bThrowErrors;

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//This function is complete!
bool CreateReplicationTables(CSQL *lpCSQL, char *sTrgDB, char *sDB, char *sDBO, char *sTable)
{
	//WriteCon("CreateReplicationTables::");
	//WriteCon(sTable);
	//WriteCon("\n");

	char sSmlTmp[64];
	char sLargeSQL[10240];
	
	CGetPKs cGetPKs;

	if(cGetPKs.Get(lpCSQL, sDB, sDBO, sTable))
	{
		int iKey = 0;

		sprintf(sLargeSQL, "CREATE TABLE [%s].[%s].[SQLExch_%s_%s_Trans] (\r\n", sTrgDB, sDBO, sDB, sTable);
		//strcat(sLargeSQL, "\t[SQLExch_ID] Numeric NOT NULL IDENTITY(1, 1),\r\n");

		while(iKey < cGetPKs.iPKs)
		{
			strcat(sLargeSQL, "\t[");
			strcat(sLargeSQL, cGetPKs.sPKs[iKey]);
			strcat(sLargeSQL, "] ");

			strcat(sLargeSQL, cGetPKs.sPKType[iKey]);

			if(cGetPKs.iPKStatus[iKey] != 0)
			{
				sprintf(sSmlTmp, " (%d)", cGetPKs.iPKLen[iKey]);
				strcat(sLargeSQL, sSmlTmp);
			}

			strcat(sLargeSQL, " NULL,\r\n");

			iKey++;
		}

		//-------------------------------------------------------------
		//Need to add a SQLExch_Pending Bit column to each of the new tables.
		//	We use this column because of the following scenario:
		//		
		//		1) When a transfer begins we need to update SQLExch_Pending = 1.
		//		2) Next we need to select all of the rows where SQLExch_Pending = 1.
		//		3) While the Server and client excange data, and do imports and exports,
		//			the data may have changed, adding more rows to the table with a
		//			SQLExch_Pending flag equal to 0
		//		4) If the impot was a success then we delete from the table where SQLExch_Pending = 1
		//		5) The rows that were added durring the server/client conversation are
		//			preserved for the next transfer
		//-------------------------------------------------------------
		strcat(sLargeSQL, "\t[SQLExch_Action] INT NOT NULL,\r\n");
		strcat(sLargeSQL, "\t[SQLExch_Pending] Bit\r\n");
		strcat(sLargeSQL, ") ON [PRIMARY]\r\n");

		lpCSQL->ExecuteNonQuery(sLargeSQL);

		cGetPKs.Free();
	}

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//This function is complete!
bool CreateReplicationTriggers(CSQL *lpCSQL, char *sTrgDB, char *sDB, char *sDBO, char *sTable)
{
	//WriteCon("CreateReplicationTriggers\n");

	char sLargeBaseSQL[10240];
	char sLargeSQL[10240];

	CGetPKs cGetPKs;

	if(cGetPKs.Get(lpCSQL, sDB, sDBO, sTable))
	{
		int iKey = 0;

		strcpy(sLargeSQL, "");
		while(iKey < cGetPKs.iPKs)
		{
			strcat(sLargeSQL, "[");
			strcat(sLargeSQL, cGetPKs.sPKs[iKey]);
			strcat(sLargeSQL, "] ");

			if(iKey != (cGetPKs.iPKs - 1))
			{
				strcat(sLargeSQL, ",");
			}

			iKey++;
		}

		cGetPKs.Free();

		sprintf(sLargeBaseSQL, "CREATE TRIGGER [SQLExch_%s_%s_%%s_Trigger] ON [%s].[%s]\r\n"
			"\tFOR %%s\r\n"
			"\tAS\r\n"
			"\t\tINSERT INTO [%s].[%s].[SQLExch_%s_%s_Trans] (%s, SQLExch_Action)\r\n\t\t\tSELECT %s, '%%s' FROM %%s\r\n"
			"GO\r\nINSERT INTO [%s].[%s].[SQLExch_Trans]([TransTable], [TransDB]) VALUES('%s', '%s')", 
			sDB, sTable, sDBO, sTable,
			sTrgDB, sDBO, sDB, sTable, sLargeSQL, sLargeSQL,
			sTrgDB, sDBO, sTable, sDB);

		sprintf(sLargeSQL, sLargeBaseSQL, "Update", "INSERT, UPDATE", "1", "Inserted");
		lpCSQL->ExecuteNonQuery(sLargeSQL);

		sprintf(sLargeSQL, sLargeBaseSQL, "Delete", "DELETE", "2", "Deleted");
		lpCSQL->ExecuteNonQuery(sLargeSQL);
	}

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//This function is complete!
bool CreateReplicationEx(CSQL *lpCSQL, char *sTrgDB, char *sDB, char *sDBO, char *sTable, HWND Grid_hWnd, int iCol, int iItem)
{
	//WriteCon("CreateReplication\n");

	GenerateReplicationScripts(NULL, sTrgDB, sDB, sDBO, false);

	lpCSQL->bThrowErrors = false;
	SetStatus(Grid_hWnd, iCol, iItem, "Dropping Triggers.");
	DropReplicationTriggers(lpCSQL, sDB, sTable);

	SetStatus(Grid_hWnd, iCol, iItem, "Dropping Tables.");
	DropReplicationTables(lpCSQL, sTrgDB, sDB, sDBO, sTable);
	lpCSQL->bThrowErrors = true;

	SetStatus(Grid_hWnd, iCol, iItem, "Creating Tables.");
	if(CreateReplicationTables(lpCSQL, sTrgDB, sDB, sDBO, sTable))
	{
		SetStatus(Grid_hWnd, iCol, iItem, "Creating Triggers.");
		return CreateReplicationTriggers(lpCSQL, sTrgDB, sDB, sDBO, sTable);
	}

	return false;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//This function is complete!
bool CreateReplication(CSQL *lpCSQL, char *sTrgDB, char *sDB, char *sDBO, char *sTable)
{
	return CreateReplicationEx(lpCSQL, sTrgDB, sDB, sDBO, sTable, NULL, 0, 0);
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool GenerateReplicationScripts(CStatusDlg *lpDlg, char *sTrgDB, char *sDB, char *sDBO, bool bCreate)
{
	//WriteCon("GenerateReplicationScripts\n");

	char sSQL[10240];
	int iTempSz = 0;
	int iLen = 0;
	long lSeq = 1000;
	long lLoop = 0;

	FILE *hSource = NULL;

	char sOnSuccess[1024];
	char sOnFailure[1024];

	char sWhereClause[10240];
	char sLargeSQL[10240];
	char sPKList[5120];
	char sTable[1024];
	char sTemp[1024];

	CGetPKs cGetPKs;

	CSQL cSQL;
	CRecordSet rsTables;

	SQLTEMPLATE MySQLTemp;

	memset(&MySQLTemp, 0, sizeof(MySQLTemp));

	if(lpDlg)
	{
		lpDlg->SetText("Generating scripts required for replication.");
		lpDlg->SetProgressPos(0);
	}

	if(!cSQL.Connect(gsSQLDriver, gsSQLServer, gsSQLUserID, gsSQLPassword, "Master"))
	{
		MsgBox("Failed to connect to the SQL server.");
		return false;
	}

	MySQLTemp.iMask = SQLTMP_DBDIR | SQLTMP_DB;
	MySQLTemp.sDBDir = gsSQLDataFiles;
	MySQLTemp.sDB = sTrgDB;
	if(BuildSQLFromTemplate(gsPath, "SQLExch_Create_DB.sql", sSQL, &MySQLTemp))
	{
		sprintf(sLargeSQL, "IF (SELECT Count(*) FROM SysDatabases WHERE Name = 'SQLExch_Replication') = 0\r\n%s", sSQL);
		cSQL.ExecuteNonQuery(sLargeSQL);
	}
	else{
	cSQL.Disconnect();
		return false;
	}

	cSQL.bThrowErrors = false;
	sprintf(sSQL, "CREATE TABLE [%s].[%s].[SQLExch_Trans] (\r\n"
		"[TransDB] [varchar] (255) NULL,\r\n"
		"[TransTable] [varchar] (255) NULL,\r\n"
		"[SQLExch_Pending] [Bit] NULL\r\n"
		") ON [PRIMARY]", sTrgDB, sDBO);
	cSQL.ExecuteNonQuery(sSQL);
	cSQL.bThrowErrors = true;

	MySQLTemp.iMask = SQLTMP_DBDIR | SQLTMP_DB;
	MySQLTemp.sDBDir = gsSQLDataFiles;
	MySQLTemp.sDB = sTrgDB;
	if(BuildSQLFromTemplate(gsPath, "SQLExch_Statements.sql", sSQL, &MySQLTemp))
	{
		//Drop the SQLExch_Statements table.
		sprintf(sLargeSQL, "DROP TABLE [%s].[%s].[SQLExch_Statements]", sTrgDB, sDBO);
		cSQL.bThrowErrors = false;
		cSQL.ExecuteNonQuery(sLargeSQL); 
		cSQL.bThrowErrors = true;

		//Recreate the SQLExch_Statements table.
		cSQL.ExecuteNonQuery(sSQL);
	}
	else{
		cSQL.Disconnect();
		return false;
	}

	if(!bCreate)
	{
		cSQL.Disconnect();
		return true;
	}

	//----------------------------------------------------------------------------------------------------

	//Create a record set containing all of the table names that contain SQLExch_ triggers
	sprintf(sSQL, "SELECT Name"
		" FROM [%s].[%s].SysObjects"
		" WHERE xType = 'U' AND (LEFT(NAME, 8) <> 'SQLExch_' AND"
		" ID IN (SELECT Parent_Obj FROM [%s].[%s].SysObjects AS A"
		" WHERE A.xType = 'TR' AND LEFT(A.NAME, 8) = 'SQLExch_'))"
		//" OR Name = 'SQLExch_Statements'"
		" ORDER BY Name", sDB, sDBO, sDB, sDBO);
	cSQL.Execute(sSQL, &rsTables);

	if(lpDlg)
	{
		lpDlg->SetProgressRange(0, rsTables.RowCount);
	}

	//Loop through all of the tables that have triggers.
	while(rsTables.Fetch())
	{
		//Get the table name, save it in sTable[]
		rsTables.sColumnEx(1, sTable, sizeof(sTable), &iTempSz);

		//Get a list of primary keys for the table.
		if(cGetPKs.Get(&cSQL, sDB, sDBO, sTable))
		{
			int iTrgTable = 0;

			//----------------------------------------------------------------------------------------
			//Insert the first statement into the "SQLExch_Statements" table.
			//----------------------------------------------------------------------------------------

			sprintf(sTemp, "UPDATE [%s].[%s].[SQLExch_%s_%s_Trans] SET SQLExch_Pending = 1",
				sTrgDB, sDBO, sDB, sTable);

			sprintf(sSQL, "INSERT INTO [%s].[%s].SQLExch_Statements (Statement, OnSuccess,"
				" Sequence, Active, TransTable, TransDB, Comments)"
				" VALUES('%s', NULL, '%d', '1', '%s', '%s', 'Auto Generated.')",
				sTrgDB, sDBO, sTemp, lSeq, sTable, sDB);
			cSQL.ExecuteNonQuery(sSQL);
			lSeq = (lSeq + 10);

			//----------------------------------------------------------------------------------------

			int iKey = 0;

			strcpy(sWhereClause, "WHERE");

			strcpy(sPKList, "");

			//Loop through all of the primary keys
			while(iKey < cGetPKs.iPKs)
			{
				strcat(sWhereClause, " [");
				strcat(sWhereClause, sTable);
				strcat(sWhereClause, "].");

				strcat(sWhereClause, "[");
				strcat(sWhereClause, cGetPKs.sPKs[iKey]);
				strcat(sWhereClause, "] = ");

				strcat(sWhereClause, "[SQLExch_Trans].");

				strcat(sWhereClause, "[");
				strcat(sWhereClause, cGetPKs.sPKs[iKey]);
				strcat(sWhereClause, "] AND");

				strcat(sPKList, "[");
				strcat(sPKList, cGetPKs.sPKs[iKey]);
				strcat(sPKList, "]");
				if(iKey != cGetPKs.iPKs - 1)
				{
					strcat(sPKList, ", ");
				}

				iKey++;
			}

			//----------------------------------------------------------------------------------------
			//Write the 'Updated / Inserted Records' statement.
			//----------------------------------------------------------------------------------------

			//Default OnFailure SQL.
			sprintf(sOnFailure, "UPDATE [%s].[%s].[SQLExch_Trans]"
				" SET [SQLExch_Pending] = 0"
				" WHERE [SQLExch_Pending] = 1 AND [TransTable] = ''%s''",
				sTrgDB, sDBO, sTable);

			//Default sOnSuccess SQL.
			sprintf(sOnSuccess, "DELETE FROM [%s].[%s].[SQLExch_%s_%s_Trans]"
				" WHERE SQLExch_Pending = 1 AND [SQLExch_Action] = 1",
				sTrgDB, sDBO, sDB, sTable);

			//We need to be able to select DISTINCT, but the ntext, text, image types dont like it.
			//sprintf(sLargeSQL, "SELECT DISTINCT %s.*"
			sprintf(sLargeSQL, "SELECT [%s].*"
				" FROM %s, [%s].[%s].[SQLExch_%s_%s_Trans] AS [SQLExch_Trans]"
				" %s [SQLExch_Trans].[SQLExch_Pending] = 1 AND"
				" [SQLExch_Trans].[SQLExch_Action] = 1",
				sTable, sTable, sTrgDB, sDBO, sDB, sTable, sWhereClause);

			sprintf(sSQL, "INSERT INTO [%s].[%s].SQLExch_Statements (Statement, OnSuccess,"
				" OnFailure, ImportTable, Sequence, Active, TransTable, TransDB, Comments)"
				" VALUES('%s', '%s', '%s', '%s', '%d', '1', '%s', '%s', 'Auto Generated.')",
				sTrgDB, sDBO, sLargeSQL, sOnSuccess, sOnFailure, sTable, lSeq, sTable, sDB);
			cSQL.ExecuteNonQuery(sSQL);
			lSeq = (lSeq + 10);

			//----------------------------------------------------------------------------------------
			//Write the 'Deleted Records' statement.
			//----------------------------------------------------------------------------------------

			//No default OnFailure SQL.
			strcpy(sOnFailure, "");
			
			//Default sOnSuccess SQL.
			sprintf(sOnSuccess, "DELETE FROM [%s].[%s].[SQLExch_%s_%s_Trans]"
				" WHERE SQLExch_Pending = 1 AND [SQLExch_Action] = 2",
				sTrgDB, sDBO, sDB, sTable);

			//We need to be able to select DISTINCT, but the ntext, text, image types dont like it.
			//sprintf(sLargeSQL, "SELECT DISTINCT %s.*"
			sprintf(sLargeSQL, "SELECT %s"
				" FROM [%s].[%s].[SQLExch_%s_%s_Trans]"
				" WHERE [SQLExch_Pending] = 1 AND [SQLExch_Action] = 2",
				sPKList, sTrgDB, sDBO, sDB, sTable);

			sprintf(sSQL, "INSERT INTO [%s].[%s].SQLExch_Statements (Statement, OnSuccess,"
				"  ImportTable, Sequence, Active, TransTable, TransDB, Comments)"
				" VALUES('%s', '%s', '%s_SQLExch_Delete', '%d', '1', '%s', '%s', 'Auto Generated.')",
				sTrgDB, sDBO, sLargeSQL, sOnSuccess, sTable, lSeq, sTable, sDB);
			cSQL.ExecuteNonQuery(sSQL);
			lSeq = (lSeq + 10);

			cGetPKs.Free();
		}

		if(lpDlg)
		{
			lLoop++;
			lpDlg->SetProgressPos(lLoop);
		}
	}

	if(lpDlg)
	{
		lpDlg->SetProgressPos(0);
	}

	rsTables.Close();
	cSQL.Disconnect();

	return true;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
